package ru.yandex.mail.hackathon.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractHackathonConfigBuilder
    <T extends AbstractHackathonConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements HackathonConfig
{
    private HttpHostConfigBuilder msearchProxyConfig;
    private HttpHostConfigBuilder blackboxConfig;
    private String calendarHost;

    protected AbstractHackathonConfigBuilder(final HackathonConfig config) {
        super(config);
        msearchProxyConfig(config.msearchProxyConfig());
        blackboxConfig(config.blackboxConfig());
        calendarHost(config.calendarHost());
    }

    protected AbstractHackathonConfigBuilder(
        final IniConfig config,
        final HackathonConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        msearchProxyConfig = new HttpHostConfigBuilder(
            config.section("msearch-proxy"),
            defaults.msearchProxyConfig());
        blackboxConfig = new HttpHostConfigBuilder(
            config.section("blackbox"),
            defaults.blackboxConfig());
        calendarHost = CALENDAR_HOST.extract(config, defaults.calendarHost());
    }

    @Override
    public HttpHostConfigBuilder msearchProxyConfig() {
        return msearchProxyConfig;
    }

    public T msearchProxyConfig(final HttpHostConfig msearchProxyConfig) {
        this.msearchProxyConfig =
            new HttpHostConfigBuilder(msearchProxyConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackboxConfig() {
        return blackboxConfig;
    }

    public T blackboxConfig(final HttpHostConfig blackboxConfig) {
        this.blackboxConfig = new HttpHostConfigBuilder(blackboxConfig);
        return self();
    }

    @Override
    public String calendarHost() {
        return calendarHost;
    }

    public T calendarHost(final String calendarHost) {
        this.calendarHost = calendarHost;
        return self();
    }
}

