package ru.yandex.mail.hackathon.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class HackathonConfigBuilder
    extends AbstractHackathonConfigBuilder<HackathonConfigBuilder>
{
    public HackathonConfigBuilder() {
        super(HackathonConfigDefaults.INSTANCE);
    }

    public HackathonConfigBuilder(final HackathonConfig config) {
        super(config);
    }

    public HackathonConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, HackathonConfigDefaults.INSTANCE);
    }

    public HackathonConfigBuilder(
        final IniConfig config,
        final HackathonConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public HackathonConfigBuilder self() {
        return this;
    }

    public ImmutableHackathonConfig build() throws ConfigException {
        return new ImmutableHackathonConfig(this);
    }
}

