package ru.yandex.mail.hackathon.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableHackathonConfig
    extends ImmutableHttpProxyConfig
    implements HackathonConfig
{
    private final ImmutableHttpHostConfig msearchProxyConfig;
    private final ImmutableHttpHostConfig blackboxConfig;
    private final String calendarHost;

    public ImmutableHackathonConfig(final HackathonConfig config)
        throws ConfigException
    {
        super(config);
        msearchProxyConfig =
            new ImmutableHttpHostConfig(config.msearchProxyConfig());
        blackboxConfig =
            new ImmutableHttpHostConfig(config.blackboxConfig());
        calendarHost = CALENDAR_HOST.validate(config.calendarHost());
    }

    @Override
    public ImmutableHttpHostConfig msearchProxyConfig() {
        return msearchProxyConfig;
    }

    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }

    @Override
    public String calendarHost() {
        return calendarHost;
    }
}

