OWNER(lemeh)
JAVA_PROGRAM(hackathon)

JDK_VERSION(11)

INCLUDE(${ARCADIA_ROOT}/mail/persdata/build/stricter_java_check.inc)

JAVA_SRCS(SRCDIR main/java **/*.java)

PEERDIR(
    alice/megamind/protos/scenarios
    mail/library/blackbox
    mail/search/search_result
    mail/search/search_proxy
    mail/library/http/http_proxy
    mail/library/hackathon-java
    mail/library/hackathon/proto
    contrib/java/com/fasterxml/jackson/core/jackson-core
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/core/jackson-annotations
)

SET(JACKSON_VERSION 2.10.2)

DEPENDENCY_MANAGEMENT(
    contrib/java/com/fasterxml/jackson/core/jackson-annotations/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/core/jackson-core/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/core/jackson-databind/${JACKSON_VERSION}
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/mail/tools/templates/classpath.template.sh
    OUT ${BINDIR}/classpath.sh
    CUSTOM_PROPERTY packageName hackathon
)

END()

IF (SANITIZER_TYPE != "memory" AND SANITIZER_TYPE != "undefined")
    RECURSE_FOR_TESTS(
        test
    )
ENDIF()

