package ru.yandex.parser.html;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BodyContentHandler extends FilterContentHandler {
    private static final String SCRIPT = "script";
    private static final String STYLE = "style";
    private static final String TITLE = "title";
    private static final char[] LF = new char[] {'\n'};

    protected boolean body = false;
    protected int scriptsCount = 0;
    protected int stylesCount = 0;
    protected int titleCount = 0;

    public BodyContentHandler(final ContentHandler handler) {
        super(handler);
    }

    // CSOFF: ParameterNumber
    @Override
    public void startElement(
        final String uri,
        final String localName,
        final String qName,
        final Attributes attrs)
        throws SAXException
    {
        switch (localName) {
            case STYLE:
                ++stylesCount;
                break;

            case SCRIPT:
                ++scriptsCount;
                break;

            case TITLE:
                ++titleCount;
                break;

            default:
                break;
        }
        body = body();
        super.startElement(uri, localName, qName, attrs);
    }
    // CSON: ParameterNumber

    @Override
    public void endElement(
        final String uri,
        final String localName,
        final String qName)
        throws SAXException
    {
        switch (localName) {
            case "br":
            case "div":
            case "hr":
            case "li":
            case "p":
            case "q":
            case "rp":
            case "rt":
            case "table":
            case "tr":
                characters(LF, 0, 1);
                break;

            case STYLE:
                --stylesCount;
                break;

            case SCRIPT:
                --scriptsCount;
                break;

            case TITLE:
                --titleCount;
                break;

            default:
                break;
        }
        body = body();
        super.endElement(uri, localName, qName);
    }

    private boolean body() {
        return scriptsCount == 0 && stylesCount == 0 && titleCount == 0;
    }

    @Override
    public void characters(final char[] cbuf, final int off, final int len)
        throws SAXException
    {
        if (body) {
            super.characters(cbuf, off, len);
        }
    }

    @Override
    public void ignorableWhitespace(
        final char[] cbuf,
        final int off,
        final int len)
        throws SAXException
    {
        if (body) {
            super.ignorableWhitespace(cbuf, off, len);
        }
    }
}

