package ru.yandex.parser.html;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class FilterContentHandler implements ContentHandler {
    protected final ContentHandler handler;

    public FilterContentHandler(final ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public void characters(final char[] ch, final int start, final int length)
        throws SAXException
    {
        handler.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        handler.endDocument();
    }

    @Override
    public void endElement(
        final String uri,
        final String localName,
        final String qName)
        throws SAXException
    {
        handler.endElement(uri, localName, qName);
    }

    @Override
    public void endPrefixMapping(final String prefix) throws SAXException {
        handler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(
        final char[] ch,
        final int start,
        final int length)
        throws SAXException
    {
        handler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(final String target, final String data)
        throws SAXException
    {
        handler.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(final Locator locator) {
        handler.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(final String name) throws SAXException {
        handler.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        handler.startDocument();
    }

    // CSOFF: ParameterNumber
    @Override
    public void startElement(
        final String uri,
        final String localName,
        final String qName,
        final Attributes atts)
        throws SAXException
    {
        handler.startElement(uri, localName, qName, atts);
    }
    // CSON: ParameterNumber

    @Override
    public void startPrefixMapping(final String prefix, final String uri)
        throws SAXException
    {
        handler.startPrefixMapping(prefix, uri);
    }
}

