package ru.yandex.parser.html;

import java.io.IOException;
import java.io.Writer;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TextContentHandler extends DefaultHandler {
    private final Writer writer;

    public TextContentHandler(final Writer writer) {
        this.writer = writer;
    }

    @Override
    public void characters(final char[] ch, final int start, final int length)
        throws SAXException
    {
        try {
            writer.write(ch, start, length);
        } catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(
        final char[] ch,
        final int start,
        final int length)
        throws SAXException
    {
        characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            writer.flush();
        } catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

