package ru.yandex.sanitizer2;

import javax.annotation.Nonnull;

import org.owasp.html.HtmlTextEscapingMode;

public abstract class AbstractHtmlNode implements HtmlNode {
    private static final long serialVersionUID = 0L;

    @Nonnull
    private final HtmlTextEscapingMode escaping;

    protected AbstractHtmlNode(final HtmlTextEscapingMode escaping) {
        this.escaping = escaping;
    }

    @Override
    @Nonnull
    public HtmlTextEscapingMode escaping() {
        return escaping;
    }
}

