package ru.yandex.sanitizer2;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AbstractHtmlTag extends HtmlNode {
    @Nonnull
    String tagName();

    @Nonnull
    List<String> classes();

    @Nonnull
    List<String> sanitizedClasses();

    @Nullable
    String id();

    @Nullable
    String sanitizedId();

    @Nonnull
    Attrs attrs();

    @Nonnull
    Style style();

    // Used for <style>...</style> selectors applying to parsed DOM.
    void style(@Nonnull Style style);

    void addTextNode(String text);

    boolean addNode(HtmlNode node);
}

