package ru.yandex.sanitizer2;

import java.util.Set;

public abstract class AbstractUrlRewriter implements UrlRewriter {
    protected final Set<String> bypassSchemes;
    protected final Set<String> allowedSchemes;
    protected final UrlRewriter next;

    protected AbstractUrlRewriter(
        final Set<String> bypassSchemes,
        final Set<String> allowedSchemes,
        final UrlRewriter next)
    {
        this.bypassSchemes = bypassSchemes;
        this.allowedSchemes = allowedSchemes;
        this.next = next;
    }

    @Override
    public boolean bypassScheme(final String scheme) {
        return bypassSchemes.contains(scheme);
    }

    @Override
    public boolean allowScheme(final String scheme) {
        return allowedSchemes.contains(scheme);
    }
}

