package ru.yandex.sanitizer2;

import java.nio.charset.CharacterCodingException;
import java.util.function.Function;

import ru.yandex.digest.Fnv;
import ru.yandex.parser.uri.PctDecoder;
import ru.yandex.parser.uri.PctEncoder;
import ru.yandex.parser.uri.PctEncodingRule;
import ru.yandex.util.string.StringUtils;

public enum AttrObfuscator implements Function<String, String> {
    CLASS {
        @Override
        public String apply(final String value) {
            return fnv64(CLASS_PREFIX_HASH, value, CLASS_SUFFIX_BYTES);
        }
    },
    HREF {
        @Override
        public String apply(final String value) {
            String result = value;
            if (!result.isEmpty() && result.charAt(0) == '#') {
                String trimmed = result.substring(1);
                try {
                    PctDecoder decoder = new PctDecoder(false);
                    decoder.process(trimmed.toCharArray());
                    String obfuscated = fnv64(
                        ID_PREFIX_HASH,
                        decoder.toString(),
                        ID_SUFFIX_BYTES);
                    PctEncoder encoder =
                        new PctEncoder(PctEncodingRule.FRAGMENT);
                    encoder.process(obfuscated.toCharArray());
                    StringBuilder sb =
                        new StringBuilder(encoder.length() + 1);
                    sb.append('#');
                    encoder.toStringBuilder(sb);
                    result = new String(sb);
                } catch (CharacterCodingException e) {
                    result = null;
                }
            }
            return result;
        }
    },
    ID {
        @Override
        public String apply(final String value) {
            return fnv64(ID_PREFIX_HASH, value, ID_SUFFIX_BYTES);
        }
    };

    private static final int FNV64_LENGTH = 16;

    private static final String CLASS_PREFIX = "class#";
    private static final long CLASS_PREFIX_HASH = Fnv.fnv64(CLASS_PREFIX);
    private static final String CLASS_SUFFIX = "5576\n";
    private static final byte[] CLASS_SUFFIX_BYTES =
        StringUtils.getUtf8Bytes(CLASS_SUFFIX);

    private static final String ID_PREFIX = "#";
    private static final long ID_PREFIX_HASH = Fnv.fnv64(ID_PREFIX);
    private static final String ID_SUFFIX = "7896\n";
    private static final byte[] ID_SUFFIX_BYTES =
        StringUtils.getUtf8Bytes(ID_SUFFIX);

    private static String fnv64(
        final long prefixHash,
        final String value,
        final byte[] suffix)
    {
        StringBuilder sb = new StringBuilder(FNV64_LENGTH + value.length());
        fnv64(sb, prefixHash, value, suffix);
        return new String(sb);
    }

    private static void fnv64(
        final StringBuilder sb,
        final long prefixHash,
        final String value,
        final byte[] suffix)
    {
        long hash = Fnv.fnv64(prefixHash, value);
        hash = Fnv.fnv64(hash, suffix);
        sb.append(Long.toHexString(hash));
        sb.append(value);
    }
}

