package ru.yandex.sanitizer2;

import java.util.ArrayList;
import java.util.List;

public class AttrWithUrls {
    private final String attrValue;
    private final List<AttrUrlInfo> urls;

    public AttrWithUrls(final String attrValue, final List<AttrUrlInfo> urls) {
        this.attrValue = attrValue;
        this.urls = urls;
    }

    public String attrValue() {
        return attrValue;
    }

    public List<AttrUrlInfo> urls() {
        return urls;
    }

    public AttrWithUrls processWith(final AttrUrlProcessor urlProcessor) {
        int size = urls.size();
        if (size == 0) {
            return this;
        }
        int len = attrValue.length();
        StringBuilder sb = new StringBuilder(len);
        List<AttrUrlInfo> newUrls = new ArrayList<>(size);
        int prev = 0;
        for (int i = 0; i < size; ++i) {
            AttrUrlInfo urlInfo = urls.get(i);
            int start = urlInfo.urlStart();
            int end = urlInfo.urlEnd();
            sb.append(attrValue, prev, start);
            UrlWithClassInfo newUrlInfo = urlProcessor.process(
                attrValue.substring(start, end),
                urlInfo.urlClassId(),
                urlInfo.urlClassValue());
            if (newUrlInfo != null) {
                String newUrl = newUrlInfo.url();
                int currentPos = sb.length();
                newUrls.add(
                    new AttrUrlInfo(
                        currentPos,
                        currentPos + newUrl.length(),
                        newUrlInfo.urlClassId(),
                        newUrlInfo.urlClassValue()));
                sb.append(newUrl);
            }
            prev = end;
        }
        sb.append(attrValue, prev, len);
        return new AttrWithUrls(new String(sb), newUrls);
    }
}
