package ru.yandex.sanitizer2;

import java.net.URISyntaxException;
import java.util.Set;

import ru.yandex.net.uri.fast.FastUri;

public class BaseHrefUrlRewriter extends AbstractUrlRewriter {
    public BaseHrefUrlRewriter(
        final Set<String> bypassSchemes,
        final Set<String> allowedSchemes,
        final UrlRewriter next)
    {
        super(bypassSchemes, allowedSchemes, next);
    }

    @Override
    public FastUri sanitize(final FastUri uri, final SanitizingContext context)
        throws URISyntaxException
    {
        FastUri tmp = uri;
        if (uri.scheme() == null) {
            FastUri baseHref = context.baseHref();
            if (baseHref != null) {
                tmp = baseHref.resolve(tmp);
            }
        }
        return next.sanitize(tmp, context);
    }
}

