package ru.yandex.sanitizer2;

import java.util.Map;

import ru.yandex.collection.EqualableIdentityHashMap;

public class BasicAttrs
    extends EqualableIdentityHashMap<String, Attr>
    implements Attrs
{
    private static final long serialVersionUID = 0L;

    public BasicAttrs(final int initialCapacity) {
        super(initialCapacity);
    }

    public BasicAttrs(final Attrs attrs) {
        super(attrs);
    }

    @SuppressWarnings("IdentityHashMapUsage")
    public void merge(final Attrs attrs) {
        putAll(attrs);
    }

    public static Attrs merge(final Attrs lhs, final Attrs rhs) {
        Attrs result;
        if (lhs.isEmpty()) {
            result = rhs;
        } else if (rhs.isEmpty()) {
            result = lhs;
        } else {
            BasicAttrs attrs = new BasicAttrs(lhs);
            attrs.merge(rhs);
            result = attrs.compact();
        }
        return result;
    }

    public Attrs compact() {
        Attrs attrs;
        switch (size()) {
            case 0:
                attrs = EmptyAttrs.INSTANCE;
                break;
            case 1:
                Map.Entry<String, Attr> entry = entrySet().iterator().next();
                attrs = new SingletonAttrs(entry.getKey(), entry.getValue());
                break;
            default:
                attrs = this;
                break;
        }
        return attrs;
    }
}

