package ru.yandex.sanitizer2;

import java.util.List;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.sanitizer2.config.ImmutablePropertyConfig;

public class CssDeclaration extends AbstractStringBuilderable {
    private static final long serialVersionUID = 0L;

    private final String property;
    private final String value;
    private final boolean important;
    private final ImmutablePropertyConfig config;
    private final List<AttrUrlInfo> urls;

    public CssDeclaration(
        final String property,
        final String value,
        final boolean important,
        final ImmutablePropertyConfig config,
        final List<AttrUrlInfo> urls)
    {
        this.property = property;
        this.value = value;
        this.important = important;
        this.config = config;
        this.urls = urls;
    }

    public String property() {
        return property;
    }

    public String value() {
        return value;
    }

    public boolean important() {
        return important;
    }

    public ImmutablePropertyConfig config() {
        return config;
    }

    public List<AttrUrlInfo> urls() {
        return urls;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(property);
        sb.append(':');
        sb.append(value);
        if (important) {
            sb.append(" !important");
        }
    }
}

