package ru.yandex.sanitizer2;

import javax.annotation.Nonnull;

import com.helger.css.decl.CSSStyleRule;

import ru.yandex.sanitizer2.config.ImmutableSanitizingConfig;

public enum EmptyStyleProcessor implements StyleProcessor {
    INSTANCE;

    @Override
    public void pushTag(@Nonnull final AbstractHtmlTag tag) {
    }

    @Override
    public void applyStyle(@Nonnull final AbstractHtmlTag tag) {
    }

    @Override
    public void popTag() {
    }

    @Override
    public boolean processStyleRule(
        @Nonnull final CSSStyleRule styleRule,
        @Nonnull final SanitizingContext context)
    {
        return false;
    }

    @Override
    @Nonnull
    public StyleProcessor upgrade(
        @Nonnull final ImmutableSanitizingConfig config)
    {
        return new SimpleStyleProcessor(config);
    }
}

