package ru.yandex.sanitizer2;

import java.net.URISyntaxException;
import java.util.Set;

import ru.yandex.net.uri.fast.FastUri;

public class ForceHttpsUrlRewriter extends AbstractUrlRewriter {
    public ForceHttpsUrlRewriter(
        final Set<String> bypassSchemes,
        final Set<String> allowedSchemes,
        final UrlRewriter next)
    {
        super(bypassSchemes, allowedSchemes, next);
    }

    @Override
    public FastUri sanitize(final FastUri uri, final SanitizingContext context)
        throws URISyntaxException
    {
        if ("http".equals(uri.scheme())) {
            uri.scheme("https");
        }
        return next.sanitize(uri, context);
    }
}

