package ru.yandex.sanitizer2;

public interface HtmlCollector<E extends Exception> {
    // returns current data length
    // NB: doesn't flush
    int length();

    // String builder where data can be appended for future flush
    StringBuilder sb();

    // Flush data from temporary buffer to underlying storage
    void flush() throws E;

    // Append data to temporary buffer without flush
    void append(char c);

    void append(String str);

    void append(StringBuilder sb);

    // Append data to temporary buffer
    // May **optionally** force flush if temporary buffer grown too big
    void appendAndFlush(char c) throws E;

    void appendAndFlush(String str) throws E;
}

