package ru.yandex.sanitizer2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.owasp.html.HtmlTextEscapingMode;

public class HtmlTag extends ArrayList<HtmlNode> implements AbstractHtmlTag {
    public static final HtmlTag EMPTY_TAG =
        new HtmlTag(
            HtmlTextEscapingMode.PCDATA,
            "",
            Collections.emptyList(),
            Collections.emptyList(),
            null,
            null,
            EmptyAttrs.INSTANCE,
            EmptyStyle.INSTANCE)
        {
            @Override
            public boolean addNode(final HtmlNode node) {
                return false;
            }
        };

    private static final long serialVersionUID = 0L;

    @Nonnull
    private final HtmlTextEscapingMode escaping;
    @Nonnull
    private final String tagName;
    @Nonnull
    private final List<String> classes;
    @Nonnull
    private final List<String> sanitizedClasses;
    @Nullable
    private final String id;
    @Nullable
    private final String sanitizedId;
    @Nonnull
    private final Attrs attrs;
    @Nonnull
    private Style style;

    public HtmlTag(
        @Nonnull final HtmlTextEscapingMode escaping,
        @Nonnull final String tagName,
        @Nonnull final List<String> classes,
        @Nonnull final List<String> sanitizedClasses,
        @Nullable final String id,
        @Nullable final String sanitizedId,
        @Nonnull final Attrs attrs,
        @Nonnull final Style style)
    {
        this.escaping = escaping;
        this.tagName = tagName;
        this.classes = classes;
        this.sanitizedClasses = sanitizedClasses;
        this.id = id;
        this.sanitizedId = sanitizedId;
        this.attrs = attrs;
        this.style = style;
    }

    public HtmlTag(
        @Nonnull final List<HtmlNode> nodes,
        @Nonnull final HtmlTextEscapingMode escaping,
        @Nonnull final String tagName,
        @Nonnull final List<String> classes,
        @Nonnull final List<String> sanitizedClasses,
        @Nullable final String id,
        @Nullable final String sanitizedId,
        @Nonnull final Attrs attrs,
        @Nonnull final Style style)
    {
        super(nodes);
        this.escaping = escaping;
        this.tagName = tagName;
        this.classes = classes;
        this.sanitizedClasses = sanitizedClasses;
        this.id = id;
        this.sanitizedId = sanitizedId;
        this.attrs = attrs;
        this.style = style;
    }

    public HtmlTag(
        int initialCapacity,
        @Nonnull final HtmlTextEscapingMode escaping,
        @Nonnull final String tagName,
        @Nonnull final List<String> classes,
        @Nonnull final List<String> sanitizedClasses,
        @Nullable final String id,
        @Nullable final String sanitizedId,
        @Nonnull final Attrs attrs,
        @Nonnull final Style style)
    {
        super(initialCapacity);
        this.escaping = escaping;
        this.tagName = tagName;
        this.classes = classes;
        this.sanitizedClasses = sanitizedClasses;
        this.id = id;
        this.sanitizedId = sanitizedId;
        this.attrs = attrs;
        this.style = style;
    }

    @Override
    @Nonnull
    public HtmlTextEscapingMode escaping() {
        return escaping;
    }

    @Override
    @Nonnull
    public String tagName() {
        return tagName;
    }

    @Override
    @Nonnull
    public List<String> classes() {
        return classes;
    }

    @Override
    @Nonnull
    public List<String> sanitizedClasses() {
        return sanitizedClasses;
    }

    @Override
    @Nullable
    public String id() {
        return id;
    }

    @Override
    @Nullable
    public String sanitizedId() {
        return sanitizedId;
    }

    @Override
    @Nonnull
    public Attrs attrs() {
        return attrs;
    }

    @Override
    @Nonnull
    public Style style() {
        return style;
    }

    @Override
    public void style(final Style style) {
        this.style = style;
    }

    @Override
    public void addTextNode(final String text) {
        addNode(new HtmlText(escaping, text));
    }

    @Override
    public boolean addNode(final HtmlNode node) {
        return add(node);
    }

    @Override
    public <T, E extends Exception> T accept(
        final HtmlNodeVisitor<T, E> visitor)
        throws E
    {
        return visitor.visit(this);
    }
}

