package ru.yandex.sanitizer2;

import org.owasp.html.HtmlTextEscapingMode;

public class HtmlText extends AbstractHtmlNode {
    private static final long serialVersionUID = 0L;

    private final String text;

    public HtmlText(final HtmlTextEscapingMode escaping, final String text) {
        super(escaping);
        this.text = text;
    }

    public String text() {
        return text;
    }

    @Override
    public <T, E extends Exception> T accept(
        final HtmlNodeVisitor<T, E> visitor)
        throws E
    {
        return visitor.visit(this);
    }
}

