package ru.yandex.sanitizer2;

import ru.yandex.sanitizer2.config.ImmutablePageHeaderConfig;

public enum PageHeaderPredicateType {
    SUBSTRING {
        @Override
        public void addPredicate(
            final String name,
            final ImmutablePageHeaderConfig config,
            final MultiPageHeaderApplier pageHeaderApplier)
        {
            pageHeaderApplier.addSubstringPredicate(name, config);
        }
    },
    REGEX {
        @Override
        public void addPredicate(
            final String name,
            final ImmutablePageHeaderConfig config,
            final MultiPageHeaderApplier pageHeaderApplier)
            throws PageHeaderException
        {
            pageHeaderApplier.addRegexPredicate(name, config);
        }
    };

    public abstract void addPredicate(
        final String name,
        final ImmutablePageHeaderConfig config,
        final MultiPageHeaderApplier pageHeaderApplier)
        throws PageHeaderException;
}

