package ru.yandex.sanitizer2;

import java.net.IDN;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.Predicate;

import ru.yandex.detect.locale.LocaleDetector;
import ru.yandex.net.uri.fast.FastUriParser;

public enum PhishingHostDetector implements Predicate<String> {
    INSTANCE;

    @Override
    public boolean test(final String str) {
        String host;
        try {
            host = new FastUriParser(str).parse().host();
            if (host != null) {
                host = IDN.toUnicode(host, IDN.ALLOW_UNASSIGNED);
            }
        } catch (RuntimeException | URISyntaxException e) {
            return false;
        }
        if (host == null || host.isEmpty()) {
            return false;
        }
        char[] chars = host.toCharArray();
        int prev = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '.' || c == '\u3002' || c == '\uFF0E' || c == '\uFF61') {
                Locale locale =
                    LocaleDetector.INSTANCE.process(chars, prev, i - prev);
                if (locale == null) {
                    return true;
                }
                prev = i + 1;
            }
        }
        Locale locale =
            LocaleDetector.INSTANCE.process(chars, prev, chars.length - prev);
        return locale == null;
    }
}

