package ru.yandex.sanitizer2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import org.owasp.html.CssTokens;

import ru.yandex.collection.IntPair;
import ru.yandex.net.uri.fast.FastUri;
import ru.yandex.sanitizer2.config.ImmutablePropertyConfig;

public class SanitizingContext {
    private static final Function<Object, Map<String, IntPair<String>>>
        MAP_FACTORY = x -> new HashMap<>();

    private final StringBuilder sb = new StringBuilder();
    private final List<AttrUrlInfo> urls = new ArrayList<>();
    private final List<CssTokens.TokenType> tokenTypes = new ArrayList<>();
    // Maps from property config to cache from property value to sanitized
    // property value and context generation
    private final IdentityHashMap
        <ImmutablePropertyConfig, Map<String, IntPair<String>>>
        propertyCache = new IdentityHashMap<>();
    private int contextGeneration = 0;
    private FastUri baseHref = null;

    public StringBuilder temporaryStringBuilder() {
        sb.setLength(0);
        return sb;
    }

    public List<AttrUrlInfo> temporaryUrlsList() {
        urls.clear();
        return urls;
    }

    public List<CssTokens.TokenType> temporaryTokenTypes() {
        tokenTypes.clear();
        return tokenTypes;
    }

    public void baseHref(final FastUri baseHref) {
        ++contextGeneration;
        this.baseHref = baseHref;
    }

    public FastUri baseHref() {
        return baseHref;
    }

    public Map<String, IntPair<String>> propertyCache(
        final ImmutablePropertyConfig config)
    {
        return propertyCache.computeIfAbsent(config, MAP_FACTORY);
    }

    // Indicates how many times essential context parameters was changed
    // (like base href), so property cache could be invalidated
    public int contextGeneration() {
        return contextGeneration;
    }
}

