package ru.yandex.sanitizer2;

import java.net.URISyntaxException;
import java.util.Set;

import ru.yandex.net.uri.fast.FastUri;
import ru.yandex.sanitizer2.config.ImmutableUrlConfig;

public class SanitizingUrlRewriter extends AbstractUrlRewriter {
    private final ImmutableUrlConfig urlConfig;

    // CSOFF: ParameterNumber
    public SanitizingUrlRewriter(
        final Set<String> bypassSchemes,
        final Set<String> allowedSchemes,
        final UrlRewriter next,
        final ImmutableUrlConfig urlConfig)
    {
        super(bypassSchemes, allowedSchemes, next);
        this.urlConfig = urlConfig;
    }
    // CSON: ParameterNumber

    @Override
    public FastUri sanitize(final FastUri uri, final SanitizingContext context)
        throws URISyntaxException
    {
        if (urlConfig.allowedHosts().test(uri.host())) {
            return next.sanitize(uri, context);
        } else {
            return null;
        }
    }
}

