package ru.yandex.sanitizer2;

import java.io.EOFException;

import com.helger.css.parser.CharStream;

public class StringBuilderCharStream implements CharStream {
    private final StringBuilder str;
    private int tokenPos = 0;
    private int pos = 0;

    public StringBuilderCharStream(final StringBuilder str) {
        this.str = str;
    }

    @Override
    public char readChar() throws EOFException {
        if (pos < str.length()) {
            return str.charAt(pos++);
        } else {
            throw new EOFException();
        }
    }

    @Override
    public void backup(final int amount) {
        pos = Math.max(0, pos - amount);
    }

    @Override
    public char beginToken() throws EOFException {
        tokenPos = pos;
        return readChar();
    }

    @Override
    public String getImage() {
        return str.substring(tokenPos, pos);
    }

    @Override
    public char[] getSuffix(final int len) {
        char[] suffix = new char[len];
        str.getChars(pos - len, pos, suffix, 0);
        return suffix;
    }

    @Override
    public void done() {
    }

    @Override
    public int getBeginColumn() {
        return 1;
    }

    @Override
    public int getEndColumn() {
        return 1;
    }

    @Override
    public int getBeginLine() {
        return 1;
    }

    @Override
    public int getEndLine() {
        return 1;
    }

    @Override
    public void setTabSize(final int size) {
    }

    @Override
    public int getTabSize() {
        return 1;
    }

    @Override
    public void setTrackLineColumn(final boolean trackLineColumn) {
    }

    @Override
    public boolean isTrackLineColumn() {
        return false;
    }
}

