package ru.yandex.sanitizer2;

public class StringBuilderHtmlCollector
    implements HtmlCollector<RuntimeException>
{
    private final StringBuilder sb;

    public StringBuilderHtmlCollector(final int inputLength) {
        sb = new StringBuilder(inputLength);
    }

    @Override
    public int length() {
        return sb.length();
    }

    @Override
    public StringBuilder sb() {
        return sb;
    }

    @Override
    public void flush() {
    }

    @Override
    public void append(final char c) {
        sb.append(c);
    }

    @Override
    public void append(final String str) {
        sb.append(str);
    }

    @Override
    public void append(final StringBuilder sb) {
        this.sb.append(sb);
    }

    @Override
    public void appendAndFlush(final char c) {
        sb.append(c);
    }

    @Override
    public void appendAndFlush(final String str) {
        sb.append(str);
    }
}
