package ru.yandex.sanitizer2;

public class StyleApplyingVisitor
    implements HtmlNodeVisitor<Void, RuntimeException>
{
    private final StyleProcessor styleProcessor;

    public StyleApplyingVisitor(final StyleProcessor styleProcessor) {
        this.styleProcessor = styleProcessor;
    }

    @Override
    @SuppressWarnings("ReferenceEquality")
    public Void visit(final HtmlTag node) {
        styleProcessor.pushTag(node);
        int size = node.size();
        for (int i = 0; i < size; ++i) {
            node.get(i).accept(this);
        }
        styleProcessor.applyStyle(node);
        styleProcessor.popTag();
        return null;
    }

    @Override
    public Void visit(final HtmlCDataTag node) {
        styleProcessor.pushTag(node);
        styleProcessor.applyStyle(node);
        styleProcessor.popTag();
        return null;
    }

    @Override
    public Void visit(final HtmlText node) {
        return null;
    }
}

