package ru.yandex.sanitizer2;

import javax.annotation.Nonnull;

import com.helger.css.decl.CSSStyleRule;

import ru.yandex.sanitizer2.config.ImmutableSanitizingConfig;

public interface StyleProcessor {
    void pushTag(@Nonnull AbstractHtmlTag tag);

    // Calculate style for tag and applies it
    void applyStyle(@Nonnull AbstractHtmlTag tag);

    void popTag();

    // Process CSS style rule
    // Returns false if rule is too complex for this processor
    // In this case, processor should be upgraded
    boolean processStyleRule(
        @Nonnull CSSStyleRule styleRule,
        @Nonnull SanitizingContext context);

    // Upgrades current style processor to one that will be able to process
    // more complex CSS style rules
    // All previously accumulated rules will be transferred to a new processor
    @Nonnull
    StyleProcessor upgrade(@Nonnull ImmutableSanitizingConfig config);
}

