package ru.yandex.sanitizer2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Set;

import ru.yandex.net.uri.fast.FastUri;
import ru.yandex.net.uri.fast.FastUriParser;
import ru.yandex.parser.uri.ScanningCgiParams;
import ru.yandex.util.string.StringUtils;

public class UnproxyUrlRewriter extends AbstractUrlRewriter {
    private final String resizerHost;
    private final String resizerPath;

    // CSOFF: ParameterNumber
    public UnproxyUrlRewriter(
        final Set<String> bypassSchemes,
        final Set<String> allowedSchemes,
        final UrlRewriter next,
        final URI resizer)
    {
        super(bypassSchemes, allowedSchemes, next);
        resizerHost = resizer.getHost();
        resizerPath = resizer.getPath();
    }
    // CSON: ParameterNumber

    @Override
    public FastUri sanitize(final FastUri uri, final SanitizingContext context)
        throws URISyntaxException
    {
        FastUri result = uri;
        if (resizerHost.equals(StringUtils.toLowerCaseOrNull(uri.host()))
            && Objects.equals(resizerPath, uri.path()))
        {
            String url =
                new ScanningCgiParams(uri.query()).getString("url", null);
            if (url != null) {
                result =
                    next.sanitize(new FastUriParser(url).parse(), context);
            }
        }
        return result;
    }
}

