package ru.yandex.sanitizer2;

import java.net.URISyntaxException;
import java.util.Set;

import ru.yandex.net.uri.fast.FastUri;
import ru.yandex.net.uri.fast.FastUriParser;
import ru.yandex.util.string.StringUtils;

public class UnrelativizingUrlRewriter extends AbstractUrlRewriter {
    private final String scheme;

    public UnrelativizingUrlRewriter(
        final Set<String> bypassSchemes,
        final Set<String> allowedSchemes,
        final UrlRewriter next,
        final String scheme)
    {
        super(bypassSchemes, allowedSchemes, next);
        this.scheme = scheme;
    }

    @Override
    public FastUri sanitize(final FastUri uri, final SanitizingContext context)
        throws URISyntaxException
    {
        FastUri tmp = uri;
        if (uri.scheme() == null) {
            if (StringUtils.nullifyEmpty(uri.host()) == null
                && uri.port() == -1
                && StringUtils.nullifyEmpty(uri.userInfo()) == null
                && StringUtils.nullifyEmpty(uri.path()) == null
                && StringUtils.nullifyEmpty(uri.query()) == null)
            {
                // Only fragment is set (probably), bypass it
                return next.sanitize(uri, context);
            }
            StringBuilder sb = new StringBuilder(
                uri.expectedStringLength() + scheme.length() + 3);
            uri.toStringBuilder(sb);
            String str = sb.toString();
            sb.setLength(0);
            sb.append(scheme);
            if (str.length() >= 2
                && str.charAt(0) == '/'
                && str.charAt(1) == '/')
            {
                sb.append(':');
            } else {
                sb.append("://");
            }
            sb.append(str);
            tmp = new FastUriParser(sb).parse();
        }
        if (tmp.host() == null) {
            return null;
        } else {
            return next.sanitize(tmp, context);
        }
    }
}

