package ru.yandex.sanitizer2;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class UrlInfo implements JsonValue {
    private final int attrStart;
    private final int attrLen;
    private final AttrUrlInfo attrUrlInfo;

    public UrlInfo(
        final int attrStart,
        final int attrLen,
        final AttrUrlInfo attrUrlInfo)
    {
        this.attrStart = attrStart;
        this.attrLen = attrLen;
        this.attrUrlInfo = attrUrlInfo;
    }

    public int type() {
        return attrUrlInfo.urlClassId();
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("type");
        writer.value(attrUrlInfo.urlClassId());
        String classValue = attrUrlInfo.urlClassValue();
        if (classValue != null) {
            writer.key("classValue");
            writer.value(classValue);
        }
        writer.key("position");
        writer.startArray();
        writer.value(attrStart);
        writer.value(attrLen);
        int urlStart = attrUrlInfo.urlStart();
        writer.value(urlStart);
        writer.value(attrUrlInfo.urlEnd() - urlStart);
        writer.endArray();
        writer.endObject();
    }
}

