package ru.yandex.sanitizer2;

import ru.yandex.parser.uri.ScanningCgiParams;
import ru.yandex.parser.uri.UriParser;
import ru.yandex.sanitizer2.config.ImmutableSanitizingConfig;

public enum UrlType {
    HREF {
        @Override
        public AttrUrlInfo detectUrlClass(
            final int urlStart,
            final int urlEnd,
            final String url,
            final ImmutableSanitizingConfig config)
        {
            int type;
            if (config.detectPhishingHosts()
                && PhishingHostDetector.INSTANCE.test(url))
            {
                type = PHISHING_URL_TYPE;
            } else {
                type = 3;
            }
            return new AttrUrlInfo(urlStart, urlEnd, type, null);
        }
    },
    AUTO {
        @Override
        public AttrUrlInfo detectUrlClass(
            final int urlStart,
            final int urlEnd,
            final String url,
            final ImmutableSanitizingConfig config)
        {
            if (url.startsWith("cid:")) {
                return new AttrUrlInfo(urlStart, urlEnd, CID_URL_TYPE, null);
            } else {
                String classValue =
                    new ScanningCgiParams(new UriParser(url).queryParser())
                        .getString("yandex_class", null);
                if (classValue == null) {
                    return new AttrUrlInfo(urlStart, urlEnd, 1, null);
                } else {
                    return new AttrUrlInfo(urlStart, urlEnd, 4, classValue);
                }
            }
        }
    };

    public static final int CID_URL_TYPE = 2;
    public static final int PHISHING_URL_TYPE = 5;

    // TODO: Rename function to something appropriate
    public abstract AttrUrlInfo detectUrlClass(
        int urlStart,
        int urlEnd,
        String url,
        ImmutableSanitizingConfig config);
}

