package ru.yandex.sanitizer2.config;

import java.net.URI;
import java.util.function.Predicate;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractHiderefererConfigBuilder
    <T extends AbstractHiderefererConfigBuilder<T>>
    implements HiderefererConfig
{
    private URI hidereferer;
    private Predicate<String> whitelistHosts;
    private Predicate<String> blacklistHosts;

    protected AbstractHiderefererConfigBuilder(
        final HiderefererConfig config)
    {
        hidereferer(config.hidereferer());
        whitelistHosts(config.whitelistHosts());
        blacklistHosts(config.blacklistHosts());
    }

    protected AbstractHiderefererConfigBuilder(
        final IniConfig config,
        final HiderefererConfig defaults)
        throws ConfigException
    {
        hidereferer = HIDEREFERER.extract(config, defaults.hidereferer());
        whitelistHosts =
            WHITELIST_HOSTS.extract(config, defaults.whitelistHosts());
        blacklistHosts =
            BLACKLIST_HOSTS.extract(config, defaults.blacklistHosts());
    }

    protected abstract T self();

    @Override
    public URI hidereferer() {
        return hidereferer;
    }

    public T hidereferer(final URI hidereferer) {
        this.hidereferer = hidereferer;
        return self();
    }

    @Override
    public Predicate<String> whitelistHosts() {
        return whitelistHosts;
    }

    public T whitelistHosts(final Predicate<String> whitelistHosts) {
        this.whitelistHosts = whitelistHosts;
        return self();
    }

    @Override
    public Predicate<String> blacklistHosts() {
        return blacklistHosts;
    }

    public T blacklistHosts(final Predicate<String> blacklistHosts) {
        this.blacklistHosts = blacklistHosts;
        return self();
    }
}

