package ru.yandex.sanitizer2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.sanitizer2.PageHeaderPredicateType;

public abstract class AbstractPageHeaderConfigBuilder
    <T extends AbstractPageHeaderConfigBuilder<T>>
    implements PageHeaderConfig
{
    private PageHeaderPredicateType type;
    private String content;
    private String header;
    private String footer;

    protected AbstractPageHeaderConfigBuilder(final PageHeaderConfig config) {
        type(config.type());
        content(config.content());
        header(config.header());
        footer(config.footer());
    }

    protected AbstractPageHeaderConfigBuilder(
        final IniConfig config,
        final PageHeaderConfig defaults)
        throws ConfigException
    {
        type = TYPE.extract(config, defaults.type());
        content = CONTENT.extract(config, defaults.content());
        header = HEADER.extract(config, defaults.header());
        footer = FOOTER.extract(config, defaults.footer());
    }

    protected abstract T self();

    @Override
    public PageHeaderPredicateType type() {
        return type;
    }

    public T type(final PageHeaderPredicateType type) {
        this.type = type;
        return self();
    }

    @Override
    public String content() {
        return content;
    }

    public T content(final String content) {
        this.content = content;
        return self();
    }

    @Override
    public String header() {
        return header;
    }

    public T header(final String header) {
        this.header = header;
        return self();
    }

    @Override
    public String footer() {
        return footer;
    }

    public T footer(final String footer) {
        this.footer = footer;
        return self();
    }
}

