package ru.yandex.sanitizer2.config;

import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractPropertyAliasConfigBuilder
    <T extends AbstractPropertyAliasConfigBuilder<T>>
    implements PropertyAliasConfig
{
    private Set<String> names;
    private String defaultValue;
    private boolean terminal;

    protected AbstractPropertyAliasConfigBuilder(
        final PropertyAliasConfig config)
    {
        names(config.names());
        defaultValue(config.defaultValue());
        terminal(config.terminal());
    }

    protected AbstractPropertyAliasConfigBuilder(
        final IniConfig config,
        final PropertyAliasConfig defaults)
        throws ConfigException
    {
        names = NAMES.extract(config, defaults.names());
        defaultValue = DEFAULT_VALUE.extract(config, defaults.defaultValue());
        terminal = TERMINAL.extract(config, defaults.terminal());
    }

    protected abstract T self();

    @Override
    public Set<String> names() {
        return names;
    }

    public T names(final Set<String> names) {
        this.names = names;
        return self();
    }

    @Override
    public String defaultValue() {
        return defaultValue;
    }

    public T defaultValue(final String defaultValue) {
        this.defaultValue = defaultValue;
        return self();
    }

    @Override
    public boolean terminal() {
        return terminal;
    }

    public T terminal(final boolean terminal) {
        this.terminal = terminal;
        return self();
    }
}

