package ru.yandex.sanitizer2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractPropertyFoldConfigBuilder
    <T extends AbstractPropertyFoldConfigBuilder<T>>
    implements PropertyFoldConfig
{
    private String defaultValue;
    private boolean mandatory;
    private char separator;
    private boolean allowSpaces;
    private boolean allowCommas;
    private String requiredProperty;

    protected AbstractPropertyFoldConfigBuilder(
        final PropertyFoldConfig config)
    {
        defaultValue(config.defaultValue());
        mandatory(config.mandatory());
        separator(config.separator());
        allowSpaces(config.allowSpaces());
        allowCommas(config.allowCommas());
        requiredProperty(config.requiredProperty());
    }

    protected AbstractPropertyFoldConfigBuilder(
        final IniConfig config,
        final PropertyFoldConfig defaults)
        throws ConfigException
    {
        defaultValue = DEFAULT_VALUE.extract(config, defaults.defaultValue());
        mandatory = MANDATORY.extract(config, defaults.mandatory());
        separator = SEPARATOR.extract(config, defaults.separator());
        allowSpaces = ALLOW_SPACES.extract(config, defaults.allowSpaces());
        allowCommas = ALLOW_COMMAS.extract(config, defaults.allowCommas());
        requiredProperty =
            REQUIRED_PROPERTY.extract(config, defaults.requiredProperty());
    }

    protected abstract T self();

    @Override
    public String defaultValue() {
        return defaultValue;
    }

    public T defaultValue(final String defaultValue) {
        this.defaultValue = defaultValue;
        return self();
    }

    @Override
    public boolean mandatory() {
        return mandatory;
    }

    public T mandatory(final boolean mandatory) {
        this.mandatory = mandatory;
        return self();
    }

    @Override
    public char separator() {
        return separator;
    }

    public T separator(final char separator) {
        this.separator = separator;
        return self();
    }

    @Override
    public boolean allowSpaces() {
        return allowSpaces;
    }

    public T allowSpaces(final boolean allowSpaces) {
        this.allowSpaces = allowSpaces;
        return self();
    }

    @Override
    public boolean allowCommas() {
        return allowCommas;
    }

    public T allowCommas(final boolean allowCommas) {
        this.allowCommas = allowCommas;
        return self();
    }

    @Override
    public String requiredProperty() {
        return requiredProperty;
    }

    public T requiredProperty(final String requiredProperty) {
        this.requiredProperty = requiredProperty;
        return self();
    }
}

