package ru.yandex.sanitizer2.config;

import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractPropertyFoldsConfigBuilder
    <T extends AbstractPropertyFoldsConfigBuilder<T>>
    implements PropertyFoldsConfig
{
    private boolean foldAllEqual;
    private Map<String, PropertyFoldConfigBuilder> properties;

    protected AbstractPropertyFoldsConfigBuilder(
        final PropertyFoldsConfig config)
    {
        foldAllEqual(config.foldAllEqual());
        properties(config.properties());
    }

    protected AbstractPropertyFoldsConfigBuilder(
        final IniConfig config,
        final PropertyFoldsConfig defaults)
        throws ConfigException
    {
        foldAllEqual = FOLD_ALL_EQUAL.extract(config, defaults.foldAllEqual());

        Map<String, IniConfig> properties = config.sections();
        this.properties = new LinkedHashMap<>(properties.size() << 1);
        for (Map.Entry<String, IniConfig> entry: properties.entrySet()) {
            this.properties.put(
                entry.getKey(),
                new PropertyFoldConfigBuilder(entry.getValue()));
        }
    }

    protected abstract T self();

    @Override
    public boolean foldAllEqual() {
        return foldAllEqual;
    }

    public T foldAllEqual(final boolean foldAllEqual) {
        this.foldAllEqual = foldAllEqual;
        return self();
    }

    @Override
    public Map<String, PropertyFoldConfigBuilder> properties() {
        return properties;
    }

    public T properties(
        final Map<String, ? extends PropertyFoldConfig> properties)
    {
        this.properties = new LinkedHashMap<>(properties.size() << 1);
        for (Map.Entry<String, ? extends PropertyFoldConfig> entry
            : properties.entrySet())
        {
            this.properties.put(
                entry.getKey(),
                new PropertyFoldConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

