package ru.yandex.sanitizer2.config;

import java.net.URI;
import java.util.function.Predicate;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractResizerConfigBuilder
    <T extends AbstractResizerConfigBuilder<T>>
    implements ResizerConfig
{
    private URI uri;
    private String salt;
    private Predicate<String> whitelistHosts;

    protected AbstractResizerConfigBuilder(final ResizerConfig config) {
        uri(config.uri());
        salt(config.salt());
        whitelistHosts(config.whitelistHosts());
    }

    protected AbstractResizerConfigBuilder(
        final IniConfig config,
        final ResizerConfig defaults)
        throws ConfigException
    {
        uri = RESIZER_URI.extract(config, defaults.uri());
        salt = SALT.extract(config, defaults.salt());
        whitelistHosts =
            WHITELIST_HOSTS.extract(config, defaults.whitelistHosts());
    }

    protected abstract T self();

    @Override
    public URI uri() {
        return uri;
    }

    public T uri(final URI uri) {
        this.uri = uri;
        return self();
    }

    @Override
    public String salt() {
        return salt;
    }

    public T salt(final String salt) {
        this.salt = salt;
        return self();
    }

    @Override
    public Predicate<String> whitelistHosts() {
        return whitelistHosts;
    }

    public T whitelistHosts(final Predicate<String> whitelistHosts) {
        this.whitelistHosts = whitelistHosts;
        return self();
    }
}

