package ru.yandex.sanitizer2.config;

import java.io.IOException;
import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.collection.PatternStringPredicate;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.http.util.server.AbstractBaseServerConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSanitizer2ConfigBuilder
    <T extends AbstractSanitizer2ConfigBuilder<T>>
    extends AbstractBaseServerConfigBuilder<T>
    implements Sanitizer2Config
{
    private static final String CONFIG = "config";

    private PatternMap<RequestInfo, SanitizingConfigBuilder> sanitizers;

    protected AbstractSanitizer2ConfigBuilder(final Sanitizer2Config config) {
        super(config);
        sanitizers(config.sanitizers());
    }

    protected AbstractSanitizer2ConfigBuilder(
        final IniConfig config,
        final Sanitizer2Config defaults)
        throws ConfigException
    {
        super(config, defaults);
        try {
            sanitizers = loadSanitizers(
                config.section("sanitizer"),
                defaults.sanitizers());
        } catch (IOException e) {
            throw new ConfigException("Failed to load sanitizers configs", e);
        }
    }

    private static PatternMap<RequestInfo, SanitizingConfigBuilder>
        loadSanitizers(
            final IniConfig config,
            final PatternMap<RequestInfo, ? extends SanitizingConfig>
            defaults)
            throws ConfigException, IOException
    {
        IniConfig ini = new IniConfig(config.getInputFile(CONFIG));
        PatternMap<RequestInfo, SanitizingConfigBuilder> sanitizers =
            new PatternMap<>(
                new SanitizingConfigBuilder(ini, defaults.asterisk()));
        ini.checkUnusedKeys();
        for (Map.Entry<String, IniConfig> entry
            : config.sections().entrySet())
        {
            String section = entry.getKey();
            if (PatternStringPredicate.INSTANCE.test(section)) {
                ini = new IniConfig(entry.getValue().getInputFile(CONFIG));
                Pattern<RequestInfo> pattern =
                    RequestPatternParser.INSTANCE.apply(section);
                sanitizers.put(
                    pattern,
                    new SanitizingConfigBuilder(ini, defaults.get(pattern)));
                ini.checkUnusedKeys();
            }
        }
        return sanitizers;
    }

    @Override
    public PatternMap<RequestInfo, SanitizingConfigBuilder> sanitizers() {
        return sanitizers;
    }

    public T sanitizers(
        final PatternMap<RequestInfo, ? extends SanitizingConfig> sanitizers)
    {
        this.sanitizers =
            sanitizers.transform(config -> new SanitizingConfigBuilder(config));
        return self();
    }
}

