package ru.yandex.sanitizer2.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractShorthandPropertyConfigBuilder
    <T extends AbstractShorthandPropertyConfigBuilder<T>>
    implements ShorthandPropertyConfig
{
    private boolean inherited;
    private Pattern pattern;
    private Map<String, PropertyAliasConfigBuilder> properties;
    private PropertyFoldsConfigBuilder foldsConfig;

    protected AbstractShorthandPropertyConfigBuilder(
        final ShorthandPropertyConfig config)
    {
        inherited(config.inherited());
        pattern(config.pattern());
        properties(config.properties());
        foldsConfig(config.foldsConfig());
    }

    protected AbstractShorthandPropertyConfigBuilder(
        final IniConfig config,
        final ShorthandPropertyConfig defaults)
        throws ConfigException
    {
        inherited = INHERITED.extract(config, defaults.inherited());
        pattern = PATTERN.extract(config, defaults.pattern());

        Map<String, IniConfig> properties =
            config.section("properties").sections();
        this.properties = new LinkedHashMap<>(properties.size() << 1);
        for (Map.Entry<String, IniConfig> entry: properties.entrySet()) {
            this.properties.put(
                entry.getKey(),
                new PropertyAliasConfigBuilder(entry.getValue()));
        }

        foldsConfig = new PropertyFoldsConfigBuilder(
            config.section("fold"),
            defaults.foldsConfig());
    }

    protected abstract T self();

    @Override
    public boolean inherited() {
        return inherited;
    }

    public T inherited(final boolean inherited) {
        this.inherited = inherited;
        return self();
    }

    @Override
    public Pattern pattern() {
        return pattern;
    }

    public T pattern(final Pattern pattern) {
        this.pattern = pattern;
        return self();
    }

    @Override
    public Map<String, PropertyAliasConfigBuilder> properties() {
        return properties;
    }

    public T properties(
        final Map<String, ? extends PropertyAliasConfig> properties)
    {
        this.properties = new LinkedHashMap<>(properties.size() << 1);
        for (Map.Entry<String, ? extends PropertyAliasConfig> entry
            : properties.entrySet())
        {
            this.properties.put(
                entry.getKey(),
                new PropertyAliasConfigBuilder(entry.getValue()));
        }
        return self();
    }

    @Override
    public PropertyFoldsConfigBuilder foldsConfig() {
        return foldsConfig;
    }

    public T foldsConfig(final PropertyFoldsConfig foldsConfig) {
        this.foldsConfig = new PropertyFoldsConfigBuilder(foldsConfig);
        return self();
    }
}

