package ru.yandex.sanitizer2.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractTagConfigBuilder
    <T extends AbstractTagConfigBuilder<T>>
    implements TagConfig
{
    private String renameTo;
    private boolean requireContent;
    private boolean requireAttrs;
    private boolean combine;
    private boolean flag;
    private boolean ignoreSelfClose;
    private Map<String, PropertyConfigBuilder> attrs;

    protected AbstractTagConfigBuilder(final TagConfig config) {
        renameTo(config.renameTo());
        requireContent(config.requireContent());
        requireAttrs(config.requireAttrs());
        combine(config.combine());
        flag(config.flag());
        ignoreSelfClose(config.ignoreSelfClose());
        attrs(config.attrs());
    }

    protected AbstractTagConfigBuilder(
        final IniConfig config,
        final TagConfig defaults)
        throws ConfigException
    {
        renameTo = RENAME_TO.extract(config, defaults.renameTo());
        requireContent =
            REQUIRE_CONTENT.extract(config, defaults.requireContent());
        requireAttrs = REQUIRE_ATTRS.extract(config, defaults.requireAttrs());
        combine = COMBINE.extract(config, defaults.combine());
        flag = FLAG.extract(config, defaults.flag());
        ignoreSelfClose =
            IGNORE_SELF_CLOSE.extract(config, defaults.ignoreSelfClose());
        IniConfig attrsSection = config.section("attr");
        Set<String> attrNames = attrsSection.sections().keySet();
        attrs = new HashMap<>(attrNames.size() << 1);
        for (String attr: attrNames) {
            // Attrs defaults ignored
            attrs.put(
                attr,
                TagConfig.attributeConfigParser(attr, null)
                    .extract(attrsSection, PropertyConfigDefaults.INSTANCE));
        }
    }

    protected abstract T self();

    @Override
    public String renameTo() {
        return renameTo;
    }

    public T renameTo(final String renameTo) {
        this.renameTo = renameTo;
        return self();
    }

    @Override
    public boolean requireContent() {
        return requireContent;
    }

    public T requireContent(final boolean requireContent) {
        this.requireContent = requireContent;
        return self();
    }

    @Override
    public boolean requireAttrs() {
        return requireAttrs;
    }

    public T requireAttrs(final boolean requireAttrs) {
        this.requireAttrs = requireAttrs;
        return self();
    }

    @Override
    public boolean combine() {
        return combine;
    }

    public T combine(final boolean combine) {
        this.combine = combine;
        return self();
    }

    @Override
    public boolean flag() {
        return flag;
    }

    public T flag(final boolean flag) {
        this.flag = flag;
        return self();
    }

    @Override
    public boolean ignoreSelfClose() {
        return ignoreSelfClose;
    }

    public T ignoreSelfClose(final boolean ignoreSelfClose) {
        this.ignoreSelfClose = ignoreSelfClose;
        return self();
    }

    @Override
    public Map<String, PropertyConfigBuilder> attrs() {
        return attrs;
    }

    public T attrs(final Map<String, ? extends PropertyConfig> attrs) {
        this.attrs = new HashMap<>(attrs.size() << 1);
        for (Map.Entry<String, ? extends PropertyConfig> entry
            : attrs.entrySet())
        {
            this.attrs.put(
                entry.getKey(),
                new PropertyConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

