package ru.yandex.sanitizer2.config;

import java.util.function.Predicate;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.sanitizer2.UrlType;

public abstract class AbstractUrlConfigBuilder
    <T extends AbstractUrlConfigBuilder<T>>
    implements UrlConfig
{
    private UrlType type;
    private boolean image;
    private Predicate<String> allowedHosts;

    protected AbstractUrlConfigBuilder(final UrlConfig config) {
        type(config.type());
        image(config.image());
        allowedHosts(config.allowedHosts());
    }

    protected AbstractUrlConfigBuilder(
        final IniConfig config,
        final UrlConfig defaults)
        throws ConfigException
    {
        type = TYPE.extract(config, defaults.type());
        image = IMAGE.extract(config, defaults.image());
        allowedHosts = ALLOWED_HOSTS.extract(config, defaults.allowedHosts());
    }

    protected abstract T self();

    @Override
    public UrlType type() {
        return type;
    }

    public T type(final UrlType type) {
        this.type = type;
        return self();
    }

    @Override
    public boolean image() {
        return image;
    }

    public T image(final boolean image) {
        this.image = image;
        return self();
    }

    @Override
    public Predicate<String> allowedHosts() {
        return allowedHosts;
    }

    public T allowedHosts(final Predicate<String> allowedHosts) {
        this.allowedHosts = allowedHosts;
        return self();
    }
}

