package ru.yandex.sanitizer2.config;

import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractUrlSanitizingConfigBuilder
    <T extends AbstractUrlSanitizingConfigBuilder<T>>
    implements UrlSanitizingConfig
{
    private ResizerConfigBuilder resizerConfig;
    private boolean forceHttps;
    private boolean unproxy;
    private boolean allowRelativeUrls;
    private boolean dropPathAndQuery;
    private Set<String> bypassSchemes;
    private Set<String> allowedSchemes;
    private boolean jsonMarkup;
    private HiderefererConfigBuilder hiderefererConfig;

    protected AbstractUrlSanitizingConfigBuilder(
        final UrlSanitizingConfig config)
    {
        resizerConfig(config.resizerConfig());
        forceHttps(config.forceHttps());
        unproxy(config.unproxy());
        allowRelativeUrls(config.allowRelativeUrls());
        dropPathAndQuery(config.dropPathAndQuery());
        bypassSchemes(config.bypassSchemes());
        allowedSchemes(config.allowedSchemes());
        jsonMarkup(config.jsonMarkup());
        hiderefererConfig(config.hiderefererConfig());
    }

    protected AbstractUrlSanitizingConfigBuilder(
        final IniConfig config,
        final UrlSanitizingConfig defaults)
        throws ConfigException
    {
        ResizerConfig resizerConfigDefaults = defaults.resizerConfig();
        IniConfig resizerSection = config.sectionOrNull("resizer");
        if (resizerSection == null) {
            resizerConfig(resizerConfigDefaults);
        } else if (resizerConfigDefaults == null) {
            resizerConfig = new ResizerConfigBuilder(resizerSection);
        } else {
            resizerConfig = new ResizerConfigBuilder(
                resizerSection,
                resizerConfigDefaults);
        }
        forceHttps = FORCE_HTTPS.extract(config, defaults.forceHttps());
        unproxy = UNPROXY.extract(config, defaults.unproxy());
        allowRelativeUrls = ALLOW_RELATIVE_URLS.extract(
            config,
            defaults.allowRelativeUrls());
        bypassSchemes =
            BYPASS_SCHEMES.extract(config, defaults.bypassSchemes());
        allowedSchemes =
            ALLOWED_SCHEMES.extract(config, defaults.allowedSchemes());
        dropPathAndQuery =
            DROP_PATH_AND_QUERY.extract(config, defaults.dropPathAndQuery());
        jsonMarkup = JSON_MARKUP.extract(config, defaults.jsonMarkup());
        IniConfig hiderefererSection = config.sectionOrNull("hidereferer");
        HiderefererConfig hiderefererConfigDefaults =
            defaults.hiderefererConfig();
        if (hiderefererSection == null) {
            hiderefererConfig(hiderefererConfigDefaults);
        } else if (hiderefererConfigDefaults == null) {
            hiderefererConfig =
                new HiderefererConfigBuilder(hiderefererSection);
        } else {
            hiderefererConfig = new HiderefererConfigBuilder(
                hiderefererSection,
                hiderefererConfigDefaults);
        }
    }

    protected abstract T self();

    @Override
    public ResizerConfigBuilder resizerConfig() {
        return resizerConfig;
    }

    public T resizerConfig(final ResizerConfig resizerConfig) {
        if (resizerConfig == null) {
            this.resizerConfig = null;
        } else {
            this.resizerConfig = new ResizerConfigBuilder(resizerConfig);
        }
        return self();
    }

    @Override
    public boolean forceHttps() {
        return forceHttps;
    }

    public T forceHttps(final boolean forceHttps) {
        this.forceHttps = forceHttps;
        return self();
    }

    @Override
    public boolean unproxy() {
        return unproxy;
    }

    public T unproxy(final boolean unproxy) {
        this.unproxy = unproxy;
        return self();
    }

    @Override
    public boolean allowRelativeUrls() {
        return allowRelativeUrls;
    }

    public T allowRelativeUrls(final boolean allowRelativeUrls) {
        this.allowRelativeUrls = allowRelativeUrls;
        return self();
    }

    @Override
    public Set<String> bypassSchemes() {
        return bypassSchemes;
    }

    public T bypassSchemes(final Set<String> bypassSchemes) {
        this.bypassSchemes = bypassSchemes;
        return self();
    }

    @Override
    public Set<String> allowedSchemes() {
        return allowedSchemes;
    }

    public T allowedSchemes(final Set<String> allowedSchemes) {
        this.allowedSchemes = allowedSchemes;
        return self();
    }

    @Override
    public boolean jsonMarkup() {
        return jsonMarkup;
    }

    public T jsonMarkup(final boolean jsonMarkup) {
        this.jsonMarkup = jsonMarkup;
        return self();
    }

    @Override
    public HiderefererConfigBuilder hiderefererConfig() {
        return hiderefererConfig;
    }

    public T hiderefererConfig(final HiderefererConfig hiderefererConfig) {
        if (hiderefererConfig == null) {
            this.hiderefererConfig = null;
        } else {
            this.hiderefererConfig =
                new HiderefererConfigBuilder(hiderefererConfig);
        }
        return self();
    }

    @Override
    public boolean dropPathAndQuery() {
        return dropPathAndQuery;
    }

    public T dropPathAndQuery(boolean dropPathAndQuery) {
        this.dropPathAndQuery = dropPathAndQuery;
        return self();
    }
}

