package ru.yandex.sanitizer2.config;

import java.net.URI;
import java.util.function.Predicate;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.HostnamePredicateParser;
import ru.yandex.parser.string.URIParser;

public interface HiderefererConfig {
    ParameterConfig<URI> HIDEREFERER = new ParameterConfig<>(
        "hidereferer",
        URIParser.FRAGMENT_STRIPPING,
        GenericFunction.identity());
    ParameterConfig<Predicate<String>> WHITELIST_HOSTS = new ParameterConfig<>(
        "whitelist-hosts",
        HostnamePredicateParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Predicate<String>> BLACKLIST_HOSTS = new ParameterConfig<>(
        "blacklist-hosts",
        HostnamePredicateParser.INSTANCE,
        GenericFunction.identity());

    URI hidereferer();

    Predicate<String> whitelistHosts();

    Predicate<String> blacklistHosts();
}

