package ru.yandex.sanitizer2.config;

import java.net.URI;
import java.util.function.Predicate;

import ru.yandex.parser.config.ConfigException;

public class ImmutableHiderefererConfig implements HiderefererConfig {
    private final URI hidereferer;
    private final Predicate<String> whitelistHosts;
    private final Predicate<String> blacklistHosts;

    public ImmutableHiderefererConfig(final HiderefererConfig config)
        throws ConfigException
    {
        hidereferer = HIDEREFERER.validate(config.hidereferer());
        whitelistHosts = WHITELIST_HOSTS.validate(config.whitelistHosts());
        blacklistHosts = BLACKLIST_HOSTS.validate(config.blacklistHosts());
    }

    @Override
    public URI hidereferer() {
        return hidereferer;
    }

    @Override
    public Predicate<String> whitelistHosts() {
        return whitelistHosts;
    }

    @Override
    public Predicate<String> blacklistHosts() {
        return blacklistHosts;
    }
}

