package ru.yandex.sanitizer2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.sanitizer2.PageHeaderPredicateType;

public class ImmutablePageHeaderConfig implements PageHeaderConfig {
    private final PageHeaderPredicateType type;
    private final String content;
    private final String header;
    private final String footer;

    public ImmutablePageHeaderConfig(final PageHeaderConfig config)
        throws ConfigException
    {
        type = TYPE.validate(config.type());
        content = CONTENT.validate(config.content());
        header = HEADER.validate(config.header());
        footer = FOOTER.validate(config.footer());
    }

    @Override
    public PageHeaderPredicateType type() {
        return type;
    }

    @Override
    public String content() {
        return content;
    }

    @Override
    public String header() {
        return header;
    }

    @Override
    public String footer() {
        return footer;
    }
}

