package ru.yandex.sanitizer2.config;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.collection.CollectionCompactor;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.util.string.StringUtils;

public class ImmutablePropertyAliasConfig implements PropertyAliasConfig {
    private final Set<String> names;
    private final List<String> namesList;
    private final String defaultValue;
    private final boolean terminal;

    public ImmutablePropertyAliasConfig(final PropertyAliasConfig config)
        throws ConfigException
    {
        Set<String> names = NAMES.validate(config.names());
        int size = names.size();
        Set<String> namesCopy = new LinkedHashSet<>(size << 1);
        for (String name: names) {
            String interned = name.intern();
            namesCopy.add(interned);
        }
        this.names = CollectionCompactor.compact(namesCopy);
        namesList = CollectionCompactor.compact(new ArrayList<>(namesCopy));
        defaultValue =
            StringUtils.intern(DEFAULT_VALUE.validate(config.defaultValue()));
        terminal = TERMINAL.validate(config.terminal());
    }

    @Override
    public Set<String> names() {
        return names;
    }

    @Override
    public String defaultValue() {
        return defaultValue;
    }

    @Override
    public boolean terminal() {
        return terminal;
    }

    public List<String> namesList() {
        return namesList;
    }

    public void populateInterner(final Interner interner) {
        for (String name: namesList) {
            interner.addProperty(name);
        }
    }
}

