package ru.yandex.sanitizer2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.util.string.StringUtils;

public class ImmutablePropertyFoldConfig implements PropertyFoldConfig {
    private final String defaultValue;
    private final boolean mandatory;
    private final char separator;
    private final boolean allowSpaces;
    private final boolean allowCommas;
    private final String requiredProperty;

    public ImmutablePropertyFoldConfig(final PropertyFoldConfig config)
        throws ConfigException
    {
        defaultValue =
            StringUtils.intern(DEFAULT_VALUE.validate(config.defaultValue()));
        mandatory = MANDATORY.validate(config.mandatory());
        separator = SEPARATOR.validate(config.separator());
        allowSpaces = ALLOW_SPACES.validate(config.allowSpaces());
        allowCommas = ALLOW_COMMAS.validate(config.allowCommas());
        requiredProperty =
            StringUtils.intern(
                REQUIRED_PROPERTY.validate(config.requiredProperty()));
    }

    @Override
    public String defaultValue() {
        return defaultValue;
    }

    @Override
    public boolean mandatory() {
        return mandatory;
    }

    @Override
    public char separator() {
        return separator;
    }

    @Override
    public boolean allowSpaces() {
        return allowSpaces;
    }

    @Override
    public boolean allowCommas() {
        return allowCommas;
    }

    @Override
    public String requiredProperty() {
        return requiredProperty;
    }

    public void populateInterner(final Interner interner) {
        if (requiredProperty != null) {
            interner.addProperty(requiredProperty);
        }
    }
}

