package ru.yandex.sanitizer2.config;

import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;

public class ImmutablePropertyFoldsConfig
    implements PropertyFoldsConfig
{
    private final boolean foldAllEqual;
    private final Map<String, ImmutablePropertyFoldConfig> properties;

    public ImmutablePropertyFoldsConfig(final PropertyFoldsConfig config)
        throws ConfigException
    {
        foldAllEqual = FOLD_ALL_EQUAL.validate(config.foldAllEqual());

        Map<String, ? extends PropertyFoldConfig> properties =
            config.properties();
        this.properties = new LinkedHashMap<>(properties.size() << 1);
        for (Map.Entry<String, ? extends PropertyFoldConfig> entry
            : properties.entrySet())
        {
            this.properties.put(
                entry.getKey().intern(),
                new ImmutablePropertyFoldConfig(entry.getValue()));
        }
    }

    @Override
    public boolean foldAllEqual() {
        return foldAllEqual;
    }

    @Override
    public Map<String, ImmutablePropertyFoldConfig> properties() {
        return properties;
    }

    public void populateInterner(final Interner interner) {
        for (Map.Entry<String, ImmutablePropertyFoldConfig> entry
            : properties.entrySet())
        {
            interner.addProperty(entry.getKey());
            entry.getValue().populateInterner(interner);
        }
    }
}

