package ru.yandex.sanitizer2.config;

import java.net.URI;
import java.util.Locale;
import java.util.function.Predicate;

import ru.yandex.parser.config.ConfigException;

public class ImmutableResizerConfig
    implements ResizerConfig
{
    private final URI uri;
    private final String salt;
    private final Predicate<String> whitelistHosts;

    public ImmutableResizerConfig(final ResizerConfig config)
        throws ConfigException
    {
        uri = RESIZER_URI.validate(config.uri());
        salt = SALT.validate(config.salt());
        String resizerHost = uri.getHost();
        if (resizerHost == null) {
            throw new ConfigException("Resizer host is not set");
        }
        whitelistHosts = WHITELIST_HOSTS.validate(config.whitelistHosts())
            .or(x -> resizerHost.equals(x.toLowerCase(Locale.ROOT)));
    }

    @Override
    public URI uri() {
        return uri;
    }

    @Override
    public String salt() {
        return salt;
    }

    @Override
    public Predicate<String> whitelistHosts() {
        return whitelistHosts;
    }
}

